<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:ghd1="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v4_0/GHD_1.xsd" xmlns:ns1="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v4_0/GHD_1.xsd" xmlns:ns2="http://www.w3.org/2000/09/xmldsig#" xmlns:ns3="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v4_0/Types.xsd" xmlns:ns4="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v4_0/Trader.xsd" xmlns:tp="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v4_0/Types.xsd" xmlns:tr="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v4_0/Trader.xsd" version="1.0"> <xsl:decimal-format NaN="" decimal-separator="." grouping-separator=" "/> <xsl:output encoding="UTF-8" method="html"/> <xsl:template match="/"> <xsl:apply-templates select="*"/> </xsl:template> <!-- POCZATEK ALL --> <!-- STYL ARKUSZA --> <xsl:template match="*" mode="styl1"> <style type="text/css">body {margin:0;font-family:Verdana,Helvetica,sans-serif;font-size:10px;text-align:justify;}</style> <style type="text/css">*{font-family:Verdana,Helvetica,sans-serif;padding:3px;color:black;}</style> <style type="text/css">a{color:#3366FF;font-weight:bold;}</style> <style type="text/css">h3{padding:3px;cursor:help;}</style> <style type="text/css">h4,h5,.copyr{text-align:center;}</style> <style type="text/css">caption{font-weight:bold;}</style> <style type="text/css">table,div,td{font-size:8pt;border-color:black;}</style> <style type="text/css">table{border-top:1 solid;border-bottom:2 solid;border-left:1 solid;border-right:1 solid;}</style> <style type="text/css">th,td{border-top:1 solid;border-bottom:1 solid;border-left:1 solid;border-right:1 solid;}</style> <style type="text/css">#cont{display:none}</style> <style type="text/css">.copyr{background:#B1D8FF;font-weight:bold;}</style> <style type="text/css">.nag1 {font-size: 20px; font-weight: bold;}</style> <style type="text/css">.nag2{font-size: 20px}</style> <style type="text/css">.cz10 {font-size: 10px}</style> <style type="text/css">.cz12 {	font-size: 12px}</style> <style type="text/css">.cz18 {font-size: 18px}</style> <style type="text/css">.cz16 {font-size: 16px}</style> <style type="text/css">.cz14 {font-size: 14px}</style> </xsl:template> <!-- SZABLON STOPKI --> <xsl:template match="*" mode="stopka"> GHD-1 </xsl:template> <xsl:template match="*"> <!-- ZASTOSOWANIE STYLU --> <xsl:apply-templates mode="styl1" select="*"/> <!-- DEKLARACJE AKCYZOWE --> <xsl:apply-templates mode="dekl_GHD1" select="."/> </xsl:template> <!-- SZABLON DOT. DEKLARACJI AKCYZOWYCH --> <xsl:template match="*" mode="dekl_GHD1"> <xsl:for-each select=" ns1:Header |  ns4:* | ghd1:Header | tr:* "> <!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--> <xsl:apply-templates mode="Ident" select="."/> <!-- SZABLON DLA RODZAJU DEKLARACJI --> <xsl:apply-templates mode="rodz_dekl" select="."/> <!-- SZABLON DOT.  OKRESU ROK MIESIAC --> <xsl:apply-templates mode="rok_mc" select="."/> <!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --> <xsl:apply-templates mode="PodstawaPrawna" select="."/> <!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --> <xsl:apply-templates mode="MiejsceDekl" select="."/> <!-- SZABLON DOT. DANYCH PODATNIKA --> <xsl:apply-templates mode="DanePodatnika" select="."/> <!-- SZABLON DOT. ADRESU PODATNIKA --> <xsl:apply-templates mode="Adres" select="."/> <xsl:apply-templates mode="ObliczeniePodatkuGry" select="."/> <xsl:apply-templates mode="RozliczeniePodatkuGry" select="."/> <!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --> <xsl:apply-templates mode="OswPodatnika" select="."/> <!-- SZABLON DOT. ADNOTACJI--> <xsl:apply-templates mode="Adnotacje" select="."/> <!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--> <xsl:apply-templates mode="ObjasnieniaAkc" select="."/> </xsl:for-each> </xsl:template> <!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--> <xsl:template match="*" mode="Ident"> <table border="1" width="955"> <tr align="left" valign="top"> <td align="left" height="45" valign="middle" width="586"> <span class="cz12"> <b>1. Identyfikator Podatkowy NIP podmiotu </b> </span> </td> <td align="center" valign="middle" width="353"> <span class="nag2"> <b> <xsl:value-of select="@identifier"/> </b> </span> </td> </tr> <tr align="left" valign="top"> <td align="left" height="45" valign="top"> <b>Numer własny:</b> <span class="cz18"> <xsl:value-of select="@selfRef"/> </span> <br/> <b>Data wypełnienia deklaracji:</b> <span class="cz18"> <xsl:value-of select="@declarationDate"/> </span> </td> <td align="center" valign="bottom"> <xsl:if test="@refNumber"> Nr referencyjny nadany przez System Zefir:<br/> <xsl:value-of select="@refNumber"/> </xsl:if> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT.  RODZAJU DEKLARACJI --> <xsl:template match="*" mode="rodz_dekl"> <xsl:if test="ns1:* | ghd1:*"> <table border="1" width="956"> <tr> <td colspan="3" height="40"> <span class="nag1">GHD1</span> </td> </tr> <tr> <td height="61" width="154"/> <td width="537"> <div align="center"> <span class="nag1">INFORMACJA O DOPŁATACH W GRACH LICZBOWYCH, LOTERIACH PIENIĘŻNYCH I GRZE TELEBINGO</span> <br/> <span class="nag1"> za </span> </div> </td> <td width="243"/> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT.  OKRESU ROK MIESIAC --> <xsl:template match="*" mode="rok_mc"> <xsl:if test="ns1:* | ghd1:*"> <table border="1" width="955"> <tr> <td height="49" width="247"/> <td align="left" valign="top" width="135"> <b>4. Miesiac</b> <br/> <div align="center" class="cz18"> <xsl:value-of select="substring(@period,6,7)"/> </div> </td> <td align="left" valign="top" width="131"> <b>5. Rok </b> <br/> <div align="center" class="cz18"> <xsl:value-of select="substring(@period,1,4)"/> </div> </td> <td width="206"/> <!-- 	<td width="206" align="left" valign="top"><br> </br>  <div align = "center" class = "cz18"> </div> </td> --> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --> <xsl:template match="*" mode="PodstawaPrawna"> <xsl:if test="ns1:* | ghd1:*"> <table border="1" width="955"> <tr> <span class="cz12">Formularz przeznaczony jest dla podmiotów urządzających gry liczbowe, loterie pieniężne i grę telebingo.</span> </tr> <tr bgcolor="#CCCCCC"> <td align="left" valign="top" width="115">Podstawa prawna: </td> <td align="left" valign="top" width="824">Art. 82 ustawy z dnia 19 listopada 2009 r. o grach hazardowych (Dz. U. z 2016 r. poz. 471 z pózn. zm.), zwanej dalej ”ustawą”.</td> </tr> <tr bgcolor="#CCCCCC"> <td align="left" valign="top">Składający:</td> <td align="left" valign="top">Podmioty urządzające gry liczbowe, loterie pieniężne i grę telebingo.</td> </tr> <tr bgcolor="#CCCCCC"> <td align="left" valign="top">Termin składania:</td> <td align="left" valign="top">Do 10 dnia miesiąca następującego po miesiącu, którego dotyczy rozliczenie (art.82 pkt.1 ustawy).</td> </tr> <tr bgcolor="#CCCCCC"> <td align="left" valign="top">Miejsce składania: </td> <td align="left" valign="top">Naczelnik urzędu skarbowego właściwy zgodnie z art. 81 ustawy, zwany dalej „organem”.</td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --> <xsl:template match="*" mode="MiejsceDekl"> <xsl:if test="ns1:* | ghd1:*"> <table border="1" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td colspan="3"> <span class="nag1">A. MIEJSCE I CEL SKŁADANIA INFORMACJI</span> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="4" width="46"/> <td colspan="2"> <b>6. Organ, do którego składana jest informacja</b> <br/> <span class="cz18"> <xsl:value-of select="@taxOffice"/> </span> </td> </tr> <tr> <td class="style3" colspan="2"> <b>7. Cel złożenia formularza</b>(zaznaczyć właściwy kwadrat):  </td> </tr> <tr> <td align="left" valign="top" width="422">1. złożenie informacji <xsl:if test="@submissionAim and normalize-space(@submissionAim)='Deklaracja'"> <span class="cz14"> <b>X - </b> <xsl:value-of select="@submissionAim"/> </span> </xsl:if> </td> <td align="left" valign="top" width="471">2. korekta informacji <xsl:if test="@submissionAim and normalize-space(@submissionAim)='Korekta'"> <span class="cz14"> <b>X - </b> <xsl:value-of select="@submissionAim"/> </span> <br/> <xsl:value-of select="@justification"/> </xsl:if> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. DANYCH PODATNIKA --> <xsl:template match="*" mode="DanePodatnika"> <xsl:if test="ns1:* | ghd1:*"> <table border="1" width="955"> <tr align="left" bgcolor="#CCCCCC"> <td colspan="2"> <span class="nag1">B. DANE PODMIOTU REALIZUJACEGO MONOPOL PAŃSTWA W ZAKRESIE GIER HAZARDOWYCH</span> </td> </tr> <tr align="left" bgcolor="#CCCCCC"> <td colspan="2"> <span class="nag2">B.1. DANE IDENTYFIKACYJNE PODMIOTU</span> </td> </tr> <tr align="left"> <td bgcolor="#CCCCCC" rowspan="2" width="46"/> <td align="left" valign="top" width="893"> <b>8. Nazwa pełna</b> <br/> <br/> <xsl:for-each select=".//ns4:TaxpayerData | .//tr:TaxpayerData | .//ghd1:TaxpayerData"> <span class="cz18"> <xsl:value-of select=".//@fullName"/> </span> </xsl:for-each> <xsl:for-each select=".//ns4:PrivatePerson | .//tr:PrivatePerson | .//ghd1:PrivatePerson"> <span class="cz18"> <xsl:value-of select="//@firstName"/> </span> <span class="cz18"> <xsl:value-of select="//@surname"/> </span> <span class="cz18"> <xsl:value-of select="//@dateOfBirth"/> </span> <span class="cz18"> <xsl:value-of select="//@PESEL"/> </span> </xsl:for-each> </td> </tr> <tr> <td align="left" class="style3" valign="top"> <b>9. Numer identyfikacyjny REGON</b> <br/> <br/> <xsl:for-each select=".//ns4:TaxpayerData | .//tr:TaxpayerData | .//ghd1:TaxpayerData"> <span class="cz18"> <xsl:value-of select="//@REGON"/> </span> </xsl:for-each> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. ADRESU PODATNIKA --> <xsl:template match="*" mode="Adres"> <xsl:if test="ns1:* | ghd1:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="6"> <span class="nag2">B.2. ADRES SIEDZIBY</span> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td width="269"> <b>10. Kraj </b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@country"/> </span> </td> <td colspan="2"> <b>11. Województwo</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@provinceName"/> </span> </td> <td colspan="2"> <b>12. Powiat</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@districtName"/> </span> </td> </tr> <tr align="left" valign="top"> <td> <b>13. Gmina </b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@communeName"/> </span> </td> <td colspan="2"> <b>14. Ulica</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@street"/> </span> </td> <td width="144"> <b>15. Nr domu</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@houseNumber"/> </span> </td> <td width="151"> <b>16. Nr lokalu</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@localNumber"/> </span> </td> </tr> <tr align="left" valign="top"> <td> <b>17. Miejscowość</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@city"/> </span> </td> <td colspan="2"> <b>18. Kod pocztowy</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@postalCode"/> </span> </td> <td colspan="2"> <b>19. Poczta</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@postalName"/> </span> </td> </tr> </table> </xsl:if> </xsl:template> <xsl:template match="*" mode="ObliczeniePodatkuGry"> <xsl:if test="*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="5"> <span class="nag1"> <b>C. OBLICZENIE KWOTY DOPŁAT</b> </span> </td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="5" width="50"/> <td align="center" bgcolor="#CCCCCC" valign="middle" width="318"> <span class="cz14"> <b>Rodzaj gry </b> </span> </td> <td align="center" bgcolor="#CCCCCC" valign="middle" width="184"> <span class="cz14"> <b>Podstawa dopłaty<sup>1)</sup> </b> </span> </td> <td align="center" bgcolor="#CCCCCC" valign="middle" width="184"> <span class="cz14"> <b>Stawka dopłaty </b> </span> </td> <td align="center" bgcolor="#CCCCCC" valign="middle" width="185"> <span class="cz14"> <b>Kwota dopłat </b> </span> <div align="right" class="cz10">zł</div> </td> </tr> <tr> <td align="left" valign="top"> <span class="cz14"> <b>Gry liczbowe </b> </span> <!-- <div align="right" class="cz18" valign="top"> <xsl:value-of select=".//ghd1:Item[@typeOfGame='9']//@typeOfGame"/> </div> --> </td> <td align="left" valign="top"> <b>20.</b> <div align="right" class="cz18" valign="top"> <xsl:value-of select=".//ghd1:Item[@typeOfGame='9']/@taxBase"/> </div> </td> <td align="left" valign="top"> <b>21.</b> <div align="right" class="cz18" valign="top"> <!--<xsl:value-of select=".//ghd1:Item[@typeOfGame='9']//@taxRatePercentage * 100"/>%-->  <xsl:choose> <xsl:when test=".//ghd1:Item[@typeOfGame='9']//@taxRatePercentage"> <xsl:value-of select=".//ghd1:Item[@typeOfGame='9']//@taxRatePercentage * 100"/>% </xsl:when> <xsl:otherwise> <!--	<xsl:value-of select="0"/> --> </xsl:otherwise> </xsl:choose>  </div> </td> <td align="left" valign="top"> <b>22.</b> <div align="right" class="cz18" valign="top"> <xsl:value-of select=".//ghd1:Item[@typeOfGame='9']//@amountOfAid"/> </div> </td> </tr> <tr> <td align="left" valign="top"> <span class="cz14"> <b>Loterie pieniężne</b> </span> <!-- <div align="right" class="cz18" valign="top"> <xsl:value-of select=".//ghd1:Item[@typeOfGame='6']//@typeOfGame"/> </div>--> </td> <td align="left" valign="top"> <b>23.</b> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select=".//ghd1:Item[@typeOfGame='6']//@taxBase"/> </div> </td> <td align="left" valign="top"> <b>24.</b> <br/> <div align="right" class="cz18" valign="top"> <!-- <xsl:value-of select=".//ghd1:Item[@typeOfGame='6']//@taxRatePercentage * 100"/>%ala -->  <xsl:choose> <xsl:when test=".//ghd1:Item[@typeOfGame='6']//@taxRatePercentage"> <xsl:value-of select=".//ghd1:Item[@typeOfGame='6']//@taxRatePercentage * 100"/>% </xsl:when> <xsl:otherwise> <!--	<xsl:value-of select="0"/> --> </xsl:otherwise> </xsl:choose> </div> </td> <td align="left" valign="top"> <b>25.</b> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select=".//ghd1:Item[@typeOfGame='6']//@amountOfAid"/> </div> </td> </tr> <tr> <td align="left" valign="top"> <span class="cz14"> <b>Gra telebingo</b> </span> <!-- <div align="right" class="cz18" valign="top"> <xsl:value-of select=".//ghd1:Item[@typeOfGame='7']//@typeOfGame"/> </div> --> </td> <td align="left" valign="top"> <b>26.</b> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select=".//ghd1:Item[@typeOfGame='7']//@taxBase"/> </div> </td> <td align="left" valign="top"> <b>27.</b> <br/> <div align="right" class="cz18" valign="top"> <!-- <xsl:value-of select=".//ghd1:Item[@typeOfGame='7']//@taxRatePercentage * 100"/>%--> <xsl:choose> <xsl:when test=".//ghd1:Item[@typeOfGame='7']//@taxRatePercentage"> <xsl:value-of select=".//ghd1:Item[@typeOfGame='7']//@taxRatePercentage * 100"/>% </xsl:when> <xsl:otherwise> <!--	<xsl:value-of select="0"/> --> </xsl:otherwise> </xsl:choose> </div> </td> <td align="left" valign="top"> <b>28.</b> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select=".//ghd1:Item[@typeOfGame='7']//@amountOfAid"/> </div> </td> </tr> <tr> <td align="left" bgcolor="#CCCCCC" colspan="3" valign="top"> <b>Razem kwota dopłat</b> <br/> <br/> Suma kwot z poz. 22, 25 i 28. </td> <td align="left" bordercolor="#000000" valign="top"> <b>29.</b> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select=".//@sum"/> </div> </td> </tr> </table> <table width="955"> <tr> <td> <sup>1)</sup>Suma stawek, cen sprzedanych losów lub innych dowodów udziałów w grze, zgodnie z art. 80 ust.1 ustawy. </td> </tr> </table> <table width="955"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1">GHD-1</span> <sub style="cz9">(2)</sub> <b style="nag1">/1</b> </td> </tr> </table> </xsl:if> </xsl:template> <xsl:template match="*" mode="RozliczeniePodatkuGry"> <xsl:if test="ghd1:*"> <!-- ZNAK KONCA STRONY DO WYDRUKU --> <div style="page-break-before: always"> <!-- <table width="955" border="1"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1"><b><xsl:apply-templates select=".." mode = "stopka"/></b></span> </td> </tr> </table> --> </div> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="3"> <span class="nag1"> <b>D. ROZLICZENIE DOPŁAT</b> </span> </td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="5" width="40"/> <td width="596"> <b>Nadpłata wpłat dzinnych z ostatnio złożonej informacji</b> <br/> <br/>Kwota z poz.34 z informacji złożonej za poprzedni okres.  </td> <td align="left" valign="top" width="297"> <b>30.</b> <div align="right" class="cz18" valign="top"> <xsl:value-of select="//@excessContributSettlementOfPrevDecl"/> </div> </td> </tr> <tr> <td> <b>Wpłaty dopłat za okres, którego informacja dotyczy</b> <br/> <br/>Suma wpłat dziennych wpłaconych dopłat za okres, którego dotyczy informacja. </td> <td align="left" valign="top"> <b>31.</b> <div align="right" class="cz18" valign="top"> <xsl:value-of select="//@amountOfPaymentsDaily"/> </div> </td> </tr> <tr> <td> <b>Kwota potrąconego wynagrodzenia, o którym mowa w art. 28 §. 1 ustawy z dnia 29 sierpnia 1997 r. - Ordynacja podatkowa (Dz.U. z 2017 r. poz. 201, z póżn. zm.)</b> <br/> <br/> </td> <td align="left" valign="top"> <b>32.</b> <div align="right" class="cz18" valign="top"> <xsl:value-of select="//@amountOfDeductedRemuneration"/> </div> </td> </tr> <tr> <td> <b>Kwota do zapłaty</b> <br/> <br/> Od kwoty z poz.29 należy odjąć sumę kwot z poz.30, 31 i 32. Jeżeli różnica jest liczbą ujemną, należy wpisać 0.</td> <td align="left" valign="top"> <b>33.</b> <div align="right" class="cz18" valign="top"> <xsl:value-of select="//@toPay"/> </div> </td> </tr> <tr> <td> <b>Nadwyżka wpłat do rozliczania w następnym okresie rozliczeniowym</b> <br/> <br/> Od sumy kwot z poz.30 i 31 należy odjąć sumę kwot z poz.29 i 32. Jeżeli różnica jest liczbą ujemną, należy wpisać 0.</td> <td align="left" valign="top"> <b>34.</b> <div align="right" class="cz18" valign="top"> <xsl:value-of select="//@excessContributSettlement"/> </div> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --> <xsl:template match="*" mode="OswPodatnika"> <xsl:if test="ns1:* | ns3:* | ghd1:* | tp:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="3"> <span class="nag1">E. PODPIS OSOBY UPRAWNIONEJ DO ZŁOŻENIA INFORMACJI</span> <br/> </td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="3" width="45"/> <td align="left" valign="top" width="417"> <b>35. Nazwisko</b> <br/> <span class="cz18"> <xsl:value-of select="//@repSurname"/> </span> </td> <td align="left" valign="top" width="471"> <b>36. Imię</b> <br/> <span class="cz18"> <xsl:value-of select="//@repFirstName"/> </span> </td> </tr> <tr> <td align="left" valign="top"> <b>37. Telefon kontaktowy</b> <br/> <span class="cz18"> <xsl:value-of select="//@phone"/> </span> </td> <td align="left" valign="top"> <b>38. Adres email</b> <br/> <span class="cz18"> <xsl:value-of select="//@email"/> </span> </td> </tr> <tr> <td align="left" valign="top"> <b>39. Data sporządzenia informacji </b>(dzień - miesiąc - rok) <br/> <span class="cz18"> <xsl:value-of select="//@declarationDate"/> </span> </td> <td align="left" valign="top"> <b>40. Podpis osoby uprawnionej do złożenia informacji</b> <br/> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. ADNOTACJI--> <xsl:template match="*" mode="Adnotacje"> <xsl:if test="ns1:* | ghd1:*"> <table border="1" height="167" width="955"> <tr bgcolor="#CCCCCC"> <td class="nag1" colspan="3" height="36"> F. ADNOTACJE ORGANU </td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td rowspan="2" width="40"/> <td colspan="2" height="72"> <b>41. Uwagi organu <br/> <br/> <br/> <br/> <br/> <br/> <br/> <br/> <br/> <br/> </b> </td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td height="49" width="472"> <b>42. Identyfikator przyjmującego formularz <br/> <br/> <br/> </b> <p/> </td> <td width="421"> <b>43. Miejscowość oraz data </b> (dzień - miesiąc - rok) </td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td rowspan="2" width="40"/> <td colspan="2" height="72"> <b>44. Podpis i pieczątka przyjmującego formularz<br/> <br/> <br/> </b> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--> <xsl:template match="*" mode="ObjasnieniaAkc"> <xsl:if test="ns1:* | ghd1:*"> <table width="955"> <tr> <td> <p align="center"> <b>Pouczenie</b> <b/> </p> <p>W przypadku niewpłacenia w obowiązującym terminie kwoty z poz. 33 lub wpłacenia jej w niepełnej wysokości niniejsza informacja stanowi podstawę do wystawienia tytułu wykonawczego, zgodnie z przepisami ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz. U. z 2016 r. poz. 599, z póżn. zm.)</p> </td> </tr> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1">GHD-1</span> <sub style="cz9">(2)</sub> <b style="nag1">/2</b> </td> </tr> </table> </xsl:if> </xsl:template> <!-- KONIEC all AG--> </xsl:stylesheet>